local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// list layout.
	self.Layout = CtlListLayout_class:create( self );
	self.Layout:SetSpacing( 2 );

	// create the header.
	self.Header = CtlHeader_class:create( self.Layout:GetHandle() );
	self.Header:SetPos( 4, 4 );
	self.Header:SetSize( 128, 32 );
	self.Header:SetTitle( "Settings" );
	self.Layout:AddItem( self.Header );
	
	// create unfreeze
	self.SimplePreviews = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.SimplePreviews:SetConVar( "vmf_simple_previews" );
	self.SimplePreviews:SetText( "Simple Previews" );
	self.SimplePreviews:SetSize( 32, 32 );
	self.SimplePreviews:AddEvent( "OnValueChanged", "SimplePreviewsChecked", self );
	self.Layout:AddItem( self.SimplePreviews );
	

	
end

// unfreeze was checked.
function PANEL:SimplePreviewsChecked( value )
	// checked?
	if( value ) then
		// kindly alert them.
		print( "Sorry, this feature hasn't been implemented yet." );
	
	end

end


// perform layout
function PANEL:PerformLayout( )
	// position the layout
	self.Layout:SetPos( 4, 4 );
	self.Layout:SetSize( self:GetWide() - 8, self:GetTall() - 8 );
	
	// update
	self.Layout:Update();

end


// draw
function PANEL:Paint( )
	// pain background.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_clientsettings_panel", PANEL, "Panel" );


// create app framework control.
CtlClientSettingsPanel_class 	= Control_class:create( nil, false, "ctl_clientsettings_panel" );
